/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.flywheel.Command;
import com.panopset.flywheel.Flywheel;
import com.panopset.flywheel.Syntax;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateLine;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/panopset/flywheel/TemplateCommand;", "Lcom/panopset/flywheel/Command;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "innerPiece", "", "template", "Lcom/panopset/flywheel/Template;", "<init>", "(Lcom/panopset/flywheel/TemplateLine;Ljava/lang/String;Lcom/panopset/flywheel/Template;)V", "getInnerPiece", "()Ljava/lang/String;", "parms", "getParms", "setParms", "(Ljava/lang/String;)V", "getDescription", "getParams", "toString", "flywheel"})
public abstract class TemplateCommand
extends Command {
    @NotNull
    private final String innerPiece;
    @NotNull
    private String parms;

    public TemplateCommand(@NotNull TemplateLine templateLine, @NotNull String innerPiece, @NotNull Template template) {
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        Intrinsics.checkNotNullParameter(innerPiece, "innerPiece");
        Intrinsics.checkNotNullParameter(template, "template");
        super(template, templateLine);
        this.innerPiece = innerPiece;
        this.parms = "";
    }

    @NotNull
    public final String getInnerPiece() {
        return this.innerPiece;
    }

    @NotNull
    public final String getParms() {
        return this.parms;
    }

    public final void setParms(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.parms = string;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.getTemplateLine().getLine();
    }

    @NotNull
    public final String getParams() {
        if (this.parms.length() > Syntax.getDirective().length()) {
            CharSequence charSequence = this.parms;
            String string = Syntax.getDirective();
            Intrinsics.checkNotNullExpressionValue(string, "getDirective(...)");
            if (StringsKt.indexOf$default(charSequence, string, 0, false, 6, null) == 0) {
                Flywheel flywheel2 = this.getTemplate().getFlywheel();
                String string2 = this.parms.substring(Syntax.getDirective().length());
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                return flywheel2.getEntry(string2);
            }
        }
        return this.parms;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + " params: " + this.getParams();
    }
}

