/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel.samples;

import com.panopset.compat.Logz;
import com.panopset.compat.Rezop;
import com.panopset.compat.Streamop;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.samples.FlywheelSample;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u000eR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/panopset/flywheel/samples/FlywheelSamples;", "", "<init>", "()V", "samples", "", "Lcom/panopset/flywheel/samples/FlywheelSample;", "getSamples", "()Ljava/util/List;", "setSamples", "(Ljava/util/List;)V", "populateSample", "", "sfx", "", "list", "all", "", "find", "desc", "flywheel"})
public final class FlywheelSamples {
    @NotNull
    private List<FlywheelSample> samples = new ArrayList();

    public FlywheelSamples() {
        Class<?> clazz = this.getClass();
        String string = "%s/%s";
        Object[] objectArray = new Object[]{"/com/panopset/flywheel/samples", "index.txt"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        for (String sfx : Rezop.INSTANCE.textStreamToList(clazz.getResourceAsStream(string2))) {
            this.populateSample(sfx, this.samples);
        }
    }

    @NotNull
    public final List<FlywheelSample> getSamples() {
        return this.samples;
    }

    public final void setSamples(@NotNull List<FlywheelSample> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.samples = list;
    }

    private final void populateSample(String sfx, List<FlywheelSample> list) {
        Object[] objectArray;
        String string;
        block7: {
            block6: {
                if (sfx == null) break block6;
                if (!(((CharSequence)sfx).length() > 0)) break block7;
                String string2 = sfx.substring(0, 1);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                if (!Intrinsics.areEqual("#", string2)) break block7;
            }
            return;
        }
        FlywheelSample fs = new FlywheelSample();
        if (Intrinsics.areEqual("Choose", sfx)) {
            return;
        }
        Properties props = new Properties();
        try {
            Class<?> clazz = this.getClass();
            string = "%s/%s/%s";
            objectArray = new Object[]{"/com/panopset/flywheel/samples", sfx, "props.txt"};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            props.load(clazz.getResourceAsStream(string3));
        }
        catch (IOException e) {
            Logz.INSTANCE.errorEx(e);
            return;
        }
        fs.setName(sfx);
        Class<?> clazz = this.getClass();
        string = "%s/%s/%s";
        objectArray = new Object[]{"/com/panopset/flywheel/samples", sfx, "list.txt"};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        fs.setListText(Streamop.INSTANCE.getTextFromStream(clazz.getResourceAsStream(string4)));
        Class<?> clazz2 = this.getClass();
        string = "%s/%s/%s";
        objectArray = new Object[]{"/com/panopset/flywheel/samples", sfx, "template.txt"};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
        fs.setTemplateText(Streamop.INSTANCE.getTextFromStream(clazz2.getResourceAsStream(string5)));
        fs.setDesc(props.getProperty("desc"));
        fs.setLineBreaks(Stringop.INSTANCE.parseBoolean(props.getProperty("lineBreaks"), true));
        fs.setListBreaks(Stringop.INSTANCE.parseBoolean(props.getProperty("listBreaks"), true));
        fs.setTokens(props.getProperty("tokens", ""));
        fs.setSplitz(props.getProperty("splitz", ""));
        list.add(fs);
    }

    @NotNull
    public final List<FlywheelSample> all() {
        return this.samples;
    }

    @Nullable
    public final FlywheelSample find(@NotNull String desc) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        for (FlywheelSample fs : this.samples) {
            if (!Intrinsics.areEqual(fs.getDesc(), desc)) continue;
            return fs;
        }
        return null;
    }
}

