/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.GlobalPropertiesKt;
import com.panopset.compat.HiddenFolder;
import com.panopset.compat.Logz;
import com.panopset.compat.PersistentMapFile;
import com.panopset.compat.Stringop;
import com.panopset.fxapp.Anchor;
import com.panopset.fxapp.Bolt;
import com.panopset.fxapp.BoltBox;
import com.panopset.fxapp.FieldHelperKt;
import com.panopset.fxapp.PanApplication;
import com.panopset.fxapp.PanChoiceBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.CheckBox;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\rJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\rJ\b\u0010\u001a\u001a\u00020\u0014H$J\u0006\u0010\u001b\u001a\u00020\u0014J\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010 \u001a\u00020\rJ\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010,\u001a\u00020\rH\u0002J\b\u0010-\u001a\u00020\rH\u0002J,\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\r2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\u0016J\u0016\u00104\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0006\u00105\u001a\u000206J\u0016\u00107\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0006\u00108\u001a\u000209J\u0016\u0010:\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0006\u0010;\u001a\u00020<J\u0016\u0010=\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\r2\u0006\u0010A\u001a\u00020BJ\u0016\u0010C\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010D\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006E"}, d2={"Lcom/panopset/fxapp/Anchor;", "", "application", "Lcom/panopset/fxapp/PanApplication;", "<init>", "(Lcom/panopset/fxapp/PanApplication;)V", "anchorManager", "file", "Ljava/io/File;", "(Lcom/panopset/fxapp/PanApplication;Ljava/io/File;)V", "getApplication", "()Lcom/panopset/fxapp/PanApplication;", "getStringValue", "", "key", "getIntValue", "", "getBooleanValue", "", "toggle", "", "getArrayListValue", "Ljava/util/ArrayList;", "setDefaultValue", "value", "createWindowTitle", "updateTitle", "loadDataFromFile", "setBoltValues", "saveDataToFile", "setFile", "getPath", "getFileName", "boltBoxes", "", "Lcom/panopset/fxapp/BoltBox;", "boltDefaults", "pmf", "Lcom/panopset/compat/PersistentMapFile;", "getPmf", "()Lcom/panopset/compat/PersistentMapFile;", "setPmf", "(Lcom/panopset/compat/PersistentMapFile;)V", "setPersistentMapFile", "createDefaultPath", "createNextUntitledPath", "registerChoiceBox", "keyChain", "panChoiceBox", "Lcom/panopset/fxapp/PanChoiceBox;", "defaultValue", "choices", "registerCheckBox", "cb", "Ljavafx/scene/control/CheckBox;", "registerToggleButton", "tb", "Ljavafx/scene/control/ToggleButton;", "registerTextInputControl", "tf", "Ljavafx/scene/control/TextInputControl;", "registerSplitPaneLocations", "splitPane", "Ljavafx/scene/control/SplitPane;", "registerTabSelected", "tabPane", "Ljavafx/scene/control/TabPane;", "registerData", "boltBox", "fxapp"})
public abstract class Anchor {
    @NotNull
    private final PanApplication application;
    @NotNull
    private final Map<String, BoltBox> boltBoxes;
    @NotNull
    private final Map<String, String> boltDefaults;
    @NotNull
    private PersistentMapFile pmf;

    public Anchor(@NotNull PanApplication application) {
        Intrinsics.checkNotNullParameter(application, "application");
        this.application = application;
        this.boltBoxes = new HashMap();
        this.boltDefaults = new HashMap();
        this.pmf = new PersistentMapFile(new File(this.createDefaultPath()));
    }

    @NotNull
    public final PanApplication getApplication() {
        return this.application;
    }

    public Anchor(@NotNull PanApplication anchorManager, @NotNull File file) {
        Intrinsics.checkNotNullParameter(anchorManager, "anchorManager");
        Intrinsics.checkNotNullParameter(file, "file");
        this(anchorManager);
        this.setPersistentMapFile(file);
    }

    @NotNull
    public final String getStringValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        BoltBox boltBox = this.boltBoxes.get(key);
        Object object = boltBox;
        if (object == null || (object = ((BoltBox)object).getValue()) == null) {
            object = "";
        }
        Object value = object;
        return value;
    }

    public final int getIntValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String value = this.getStringValue(key);
        if (((CharSequence)value).length() == 0) {
            return 0;
        }
        int intValue = Integer.parseInt(value);
        return intValue;
    }

    public final boolean getBooleanValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String value = this.getStringValue(key);
        boolean booleanValue = Boolean.parseBoolean(value);
        return booleanValue;
    }

    public final void toggle(@NotNull String key) {
        block1: {
            boolean booleanValue;
            Intrinsics.checkNotNullParameter(key, "key");
            String value = this.getStringValue(key);
            boolean bl = booleanValue = !Boolean.parseBoolean(value);
            if (!this.boltBoxes.containsKey(key)) break block1;
            BoltBox boltBox = this.boltBoxes.get(key);
            if (boltBox != null) {
                boltBox.setValue(String.valueOf(booleanValue));
            }
        }
    }

    @NotNull
    public final ArrayList<String> getArrayListValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String value = this.getStringValue(key);
        ArrayList<String> arrayListValue = Stringop.INSTANCE.stringToList(value);
        return arrayListValue;
    }

    public final void setDefaultValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.boltDefaults.put(key, value);
    }

    @NotNull
    public final String createWindowTitle() {
        String string = "%s ~ %s";
        Object[] objectArray = new Object[]{this.application.getApplicationDisplayName(), this.getPath()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    protected abstract void updateTitle();

    public final void loadDataFromFile() {
        this.pmf.load();
    }

    public final void setBoltValues() {
        if (this.pmf.getFile().exists()) {
            for (Map.Entry<String, BoltBox> entry : this.boltBoxes.entrySet()) {
                String key = entry.getKey();
                BoltBox value1 = entry.getValue();
                if (!this.pmf.containsKey(key)) continue;
                String value = this.pmf.getMapValue(key);
                value1.setValue(value);
            }
        }
        this.updateTitle();
    }

    public final void saveDataToFile() {
        for (Map.Entry<String, BoltBox> entry : this.boltBoxes.entrySet()) {
            String key = entry.getKey();
            BoltBox value1 = entry.getValue();
            String value = value1.getValue();
            this.pmf.put(key, value);
        }
        this.pmf.flush();
        String string = this.pmf.getFile().getParent();
        Intrinsics.checkNotNullExpressionValue(string, "getParent(...)");
        GlobalPropertiesKt.globalPropsPut("com.panopset.global_last_parent_dir", string);
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.pmf.setNewFile(file);
    }

    @NotNull
    public final String getPath() {
        String string = this.pmf.getFile().getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue(string, "getCanonicalPath(...)");
        return string;
    }

    @NotNull
    public final String getFileName() {
        String string = this.pmf.getFile().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @NotNull
    public final PersistentMapFile getPmf() {
        return this.pmf;
    }

    public final void setPmf(@NotNull PersistentMapFile persistentMapFile) {
        Intrinsics.checkNotNullParameter(persistentMapFile, "<set-?>");
        this.pmf = persistentMapFile;
    }

    private final void setPersistentMapFile(File file) {
        this.pmf = new PersistentMapFile(file);
    }

    private final String createDefaultPath() {
        String path = "";
        while (((CharSequence)path).length() == 0 || new File(path).exists()) {
            String untitledFileName = this.createNextUntitledPath();
            path = HiddenFolder.INSTANCE.getFullPathRelativeTo("temp" + Stringop.INSTANCE.getFSP() + untitledFileName);
        }
        return path;
    }

    private final String createNextUntitledPath() {
        return this.application.getApplicationShortName() + "_Untitled" + this.application.getNextUniqueID() + ".properties";
    }

    public final void registerChoiceBox(@NotNull String keyChain, @NotNull PanChoiceBox panChoiceBox, @NotNull String defaultValue, @NotNull ArrayList<String> choices) {
        Intrinsics.checkNotNullParameter(keyChain, "keyChain");
        Intrinsics.checkNotNullParameter(panChoiceBox, "panChoiceBox");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        Intrinsics.checkNotNullParameter(choices, "choices");
        panChoiceBox.register(this, keyChain, defaultValue, choices);
    }

    public final void registerCheckBox(@NotNull String keyChain, @NotNull CheckBox cb) {
        Intrinsics.checkNotNullParameter(keyChain, "keyChain");
        Intrinsics.checkNotNullParameter(cb, "cb");
        String defaultValue = "" + cb.isSelected();
        this.registerData(keyChain, new BoltBox(new Bolt(cb, defaultValue){
            final /* synthetic */ CheckBox $cb;
            final /* synthetic */ String $defaultValue;
            {
                this.$cb = $cb;
                this.$defaultValue = $defaultValue;
            }

            public void setBoltValue(String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                if (Stringop.INSTANCE.isPopulated(value)) {
                    boolean bv = Boolean.parseBoolean(value);
                    this.$cb.setSelected(bv);
                }
            }

            public String getBoltValue() {
                return "" + this.$cb.isSelected();
            }

            public String getBoltDefault() {
                return this.$defaultValue;
            }
        }));
    }

    public final void registerToggleButton(@NotNull String keyChain, @NotNull ToggleButton tb) {
        Intrinsics.checkNotNullParameter(keyChain, "keyChain");
        Intrinsics.checkNotNullParameter(tb, "tb");
        String defaultValue = "" + tb.isSelected();
        this.registerData(keyChain, new BoltBox(new Bolt(tb, defaultValue){
            final /* synthetic */ ToggleButton $tb;
            final /* synthetic */ String $defaultValue;
            {
                this.$tb = $tb;
                this.$defaultValue = $defaultValue;
            }

            public void setBoltValue(String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                if (Stringop.INSTANCE.isPopulated(value)) {
                    boolean bv = Boolean.parseBoolean(value);
                    this.$tb.setSelected(bv);
                }
            }

            public String getBoltValue() {
                return "" + this.$tb.isSelected();
            }

            public String getBoltDefault() {
                return this.$defaultValue;
            }
        }));
    }

    public final void registerTextInputControl(@NotNull String keyChain, @NotNull TextInputControl tf) {
        Intrinsics.checkNotNullParameter(keyChain, "keyChain");
        Intrinsics.checkNotNullParameter(tf, "tf");
        if (FieldHelperKt.isPasswordField(tf)) {
            return;
        }
        if (tf.getId() == null) {
            tf.setId(keyChain);
        }
        String currentTextValue = tf.getText();
        this.registerData(keyChain, new BoltBox(new Bolt(tf, this, currentTextValue){
            final /* synthetic */ TextInputControl $tf;
            final /* synthetic */ Anchor this$0;
            final /* synthetic */ String $currentTextValue;
            {
                this.$tf = $tf;
                this.this$0 = $receiver;
                this.$currentTextValue = $currentTextValue;
            }

            public void setBoltValue(String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                Platform.runLater(() -> registerTextInputControl.1.setBoltValue$lambda$0(this.$tf, value));
            }

            public String getBoltValue() {
                String string = this.$tf.getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return string;
            }

            public String getBoltDefault() {
                String string;
                String dft = (String)Anchor.access$getBoltDefaults$p(this.this$0).get(this.$tf.getId());
                if (Stringop.INSTANCE.isBlank(dft)) {
                    String string2 = this.$currentTextValue;
                    Intrinsics.checkNotNull(string2);
                    string = string2;
                } else {
                    String string3 = dft;
                    string = string3;
                    Intrinsics.checkNotNull(string3);
                }
                return string;
            }

            private static final void setBoltValue$lambda$0(TextInputControl $tf, String $value) {
                $tf.setText($value);
            }
        }));
    }

    public final void registerSplitPaneLocations(@NotNull String keyChain, @NotNull SplitPane splitPane) {
        Intrinsics.checkNotNullParameter(keyChain, "keyChain");
        Intrinsics.checkNotNullParameter(splitPane, "splitPane");
        String currentValue = Arrays.toString(splitPane.getDividerPositions());
        this.registerData(keyChain, new BoltBox(new Bolt(splitPane, currentValue){
            final /* synthetic */ SplitPane $splitPane;
            final /* synthetic */ String $currentValue;
            {
                this.$splitPane = $splitPane;
                this.$currentValue = $currentValue;
            }

            public void setBoltValue(String value) {
                List<T> list;
                Intrinsics.checkNotNullParameter(value, "value");
                if (!Stringop.INSTANCE.isPopulated(value)) {
                    return;
                }
                if (StringsKt.equals("[]", value, true)) {
                    return;
                }
                CharSequence charSequence = StringsKt.replace$default(StringsKt.replace$default(value, "[", "", false, 4, null), "]", "", false, 4, null);
                Regex regex = new Regex(",");
                int n = 0;
                List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] str = thisCollection$iv.toArray(new String[0]);
                double[] positions = new double[str.length];
                int n2 = str.length;
                for (int i = 0; i < n2; ++i) {
                    positions[i] = Double.parseDouble(str[i]);
                }
                this.$splitPane.setDividerPositions(Arrays.copyOf(positions, positions.length));
            }

            public String getBoltValue() {
                String string = Arrays.toString(this.$splitPane.getDividerPositions());
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }

            public String getBoltDefault() {
                String string = this.$currentValue;
                Intrinsics.checkNotNull(string);
                return string;
            }
        }));
    }

    public final void registerTabSelected(@NotNull String keyChain, @NotNull TabPane tabPane) {
        Intrinsics.checkNotNullParameter(keyChain, "keyChain");
        Intrinsics.checkNotNullParameter(tabPane, "tabPane");
        int currentValue = tabPane.getSelectionModel().getSelectedIndex();
        this.registerData(keyChain, new BoltBox(new Bolt(tabPane, currentValue){
            final /* synthetic */ TabPane $tabPane;
            final /* synthetic */ int $currentValue;
            {
                this.$tabPane = $tabPane;
                this.$currentValue = $currentValue;
            }

            public String getBoltValue() {
                return "" + this.$tabPane.getSelectionModel().getSelectedIndex();
            }

            public void setBoltValue(String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                if (Stringop.INSTANCE.isPopulated(value)) {
                    try {
                        int i = Integer.parseInt(value);
                        this.$tabPane.getSelectionModel().select(i);
                    }
                    catch (NumberFormatException ex) {
                        Logz.INSTANCE.errorEx(ex);
                    }
                }
            }

            public String getBoltDefault() {
                return "" + this.$currentValue;
            }
        }));
    }

    public final void registerData(@NotNull String key, @NotNull BoltBox boltBox) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(boltBox, "boltBox");
        this.boltBoxes.computeIfAbsent(key, arg_0 -> Anchor.registerData$lambda$1(arg_0 -> Anchor.registerData$lambda$0(boltBox, arg_0), arg_0));
    }

    private static final BoltBox registerData$lambda$0(BoltBox $boltBox, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $boltBox;
    }

    private static final BoltBox registerData$lambda$1(Function1 $tmp0, Object p0) {
        return (BoltBox)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getBoltDefaults$p(Anchor $this) {
        return $this.boltDefaults;
    }
}

