/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.AppVersion;
import com.panopset.compat.Fileop;
import com.panopset.compat.GlobalPropertiesKt;
import com.panopset.compat.Logpan;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.compat.SysInfo;
import com.panopset.compat.Zombie;
import com.panopset.fxapp.Anchor;
import com.panopset.fxapp.AnchorFactory;
import com.panopset.fxapp.AppDDSFX;
import com.panopset.fxapp.DeskApp4XFactory;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactory;
import com.panopset.fxapp.StageManager;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0007J\b\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u0007H\u0002J\u0006\u0010\u001a\u001a\u00020\u0007J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005J\u0006\u0010$\u001a\u00020\u0007J\u000e\u0010%\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010)\u001a\u00020\u0007J\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lcom/panopset/fxapp/JavaFXapp;", "", "<init>", "()V", "findActiveStage", "Ljavafx/stage/Stage;", "launch", "", "stage", "doLaunch", "addStage", "addAndShow", "show", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "doSave", "doSaveAs", "doOpen", "doAbout", "logStage", "createLogStage", "update", "logTa", "Ljavafx/scene/control/TextArea;", "doShowLog", "saveOpenWindowStateGlobally", "doExit", "GLOBAL_LAST_PARENT_DIR", "", "findStage", "dds", "Lcom/panopset/fxapp/AppDDSFX;", "getDds", "()Lcom/panopset/fxapp/AppDDSFX;", "setDds", "(Lcom/panopset/fxapp/AppDDSFX;)V", "newWindow", "showAboutPanel", "showLogPanel", "saveWindow", "saveWindowAs", "openWindowFromFile", "panExit", "closeWindow", "fxapp"})
@SourceDebugExtension(value={"SMAP\nJavaFXapp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaFXapp.kt\ncom/panopset/fxapp/JavaFXapp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,331:1\n739#2,9:332\n37#3:341\n36#3,3:342\n*S KotlinDebug\n*F\n+ 1 JavaFXapp.kt\ncom/panopset/fxapp/JavaFXapp\n*L\n44#1:332,9\n44#1:341\n44#1:342,3\n*E\n"})
public final class JavaFXapp {
    @NotNull
    public static final JavaFXapp INSTANCE = new JavaFXapp();
    @Nullable
    private static Stage logStage;
    @NotNull
    public static final String GLOBAL_LAST_PARENT_DIR = "com.panopset.global_last_parent_dir";
    @Nullable
    private static AppDDSFX dds;

    private JavaFXapp() {
    }

    private final Stage findActiveStage() {
        FxDoc fxDoc = (FxDoc)AnchorFactory.INSTANCE.findAnchor();
        if (fxDoc == null) {
            return null;
        }
        FxDoc fxDoc2 = fxDoc;
        return fxDoc2.getStage();
    }

    /*
     * WARNING - void declaration
     */
    public final void launch(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        String rawFiles = GlobalPropertiesKt.globalPropsGet(DeskApp4XFactory.INSTANCE.getPanApplication().getFilesKey());
        Ref.ObjectRef fxDoc = new Ref.ObjectRef();
        if (Stringop.INSTANCE.isPopulated(rawFiles)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object = rawFiles;
            Regex regex = new Regex(",");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            int $i$f$toTypedArray = 0;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] files = thisCollection$iv.toArray(new String[0]);
            SortedSet<String> sortedFileSet = Collections.synchronizedSortedSet(new TreeSet());
            for (String rawPath : files) {
                sortedFileSet.add(rawPath);
            }
            boolean firstTime = true;
            for (String rawPath : sortedFileSet) {
                String path = URLDecoder.decode(rawPath, StandardCharsets.UTF_8);
                File file = new File(path);
                if (firstTime) {
                    fxDoc.element = DeskApp4XFactory.INSTANCE.assemblerFxDoc(stage, file);
                    this.show((FxDoc)fxDoc.element);
                    firstTime = false;
                    continue;
                }
                fxDoc.element = DeskApp4XFactory.INSTANCE.assemblerFxDoc(new Stage(), file);
                this.show((FxDoc)fxDoc.element);
            }
            GlobalPropertiesKt.globalPropsPut(DeskApp4XFactory.INSTANCE.getPanApplication().getFilesKey(), "");
        } else {
            this.addAndShow(stage);
        }
        Platform.runLater(() -> JavaFXapp.launch$lambda$1(fxDoc));
    }

    public final void doLaunch() {
        DeskApp4XFactory.INSTANCE.getDeskApp4FX().doLaunch();
    }

    private final void addStage() {
        this.addAndShow(new Stage());
    }

    private final void addAndShow(Stage stage) {
        this.show(new FxDoc(DeskApp4XFactory.INSTANCE.getPanApplication(), stage));
    }

    private final void show(FxDoc fxDoc) {
        AnchorFactory.INSTANCE.addAnchor(fxDoc);
        StageManager.INSTANCE.assembleAndShow(DeskApp4XFactory.INSTANCE.getDeskApp4FX(), fxDoc);
        fxDoc.setBoltValues();
        fxDoc.getApplication().doAfterShow(fxDoc);
    }

    private final void doSave(FxDoc fxDoc) {
        fxDoc.saveDataToFile();
        Logz.INSTANCE.green("Saved to " + fxDoc.getFileName() + ".");
    }

    private final void doSaveAs(FxDoc fxDoc) {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save as...");
        String lpd = GlobalPropertiesKt.globalPropsGet(GLOBAL_LAST_PARENT_DIR);
        if (Stringop.INSTANCE.isPopulated(lpd)) {
            fileChooser.setInitialDirectory(new File(lpd));
        }
        if ((file = fileChooser.showSaveDialog(this.findStage())) == null) {
            Logz.INSTANCE.warn("New file not set.");
            return;
        }
        fxDoc.setFile(file);
        this.doSave(fxDoc);
        fxDoc.updateTitle();
    }

    private final void doOpen() {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open a previously saved " + DeskApp4XFactory.INSTANCE.getPanApplication().getApplicationShortName() + " properties file.");
        String lpd = GlobalPropertiesKt.globalPropsGet(GLOBAL_LAST_PARENT_DIR);
        if (Stringop.INSTANCE.isPopulated(lpd)) {
            fileChooser.setInitialDirectory(new File(lpd));
        }
        if ((file = fileChooser.showOpenDialog(this.findStage())) == null) {
            Logz.INSTANCE.warn("No file selected.");
            return;
        }
        if (!file.exists()) {
            Logz.INSTANCE.warn("File " + Fileop.INSTANCE.getCanonicalPath(file) + " does not exist.");
            return;
        }
        this.show(DeskApp4XFactory.INSTANCE.assemblerFxDoc(new Stage(), file));
    }

    private final void doAbout(FxDoc fxDoc) {
        String appDisplayName = DeskApp4XFactory.INSTANCE.getPanApplication().getApplicationDisplayName();
        String companyName = DeskApp4XFactory.INSTANCE.getPanApplication().getCompanyName();
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        String string = companyName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String bannerImageName = string2;
        Image bannerImage = new Image(this.getClass().getResourceAsStream("/" + bannerImageName + ".png"));
        alert.setGraphic(new ImageView(bannerImage));
        String string3 = "About %s %s";
        Object[] objectArray = new Object[]{DeskApp4XFactory.INSTANCE.getPanApplication().getCompanyName(), DeskApp4XFactory.INSTANCE.getPanApplication().getApplicationDisplayName()};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        alert.setTitle(string4);
        Label contentHeader = new Label(DeskApp4XFactory.INSTANCE.getPanApplication().getDescription());
        TextArea contentTextArea = new TextArea("Version " + AppVersion.INSTANCE.getFullVersion() + "\n\n \u00a9 1996-2024 Karl Dinwiddie.\n\nThis program is free software for those that can't afford it: \nyou can redistribute it and/or modify it under the terms of the GNU \nGeneral Public License as published by the Free Software Foundation, \neither version 3 of the License, or (at your option) any later \nversion, along with a couple of Panopset additional provisions,\nwith regards to Panopset Blackjack:\n\n1) Under no circumstances, is the Panopset Blackjack module to be used to \ndrive a real money game. You can do whatever you want with \ncryptocurrency, that isn't real money. \n2) All front end distributions of code that uses the Panopset Blackjack \nmodule must have a link to Gamblers Anonymous. \n\nThis program is distributed in the hope that it will be useful, \nbut WITHOUT ANY WARRANTY; without even the implied warranty of \nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. \n\nPlease click the link below for the full license, it will open in your default browser.");
        Hyperlink licenceLink = new Hyperlink("https://github.com/panopset/src/blob/main/LICENSE");
        licenceLink.setOnAction(JavaFXapp::doAbout$lambda$3);
        BorderPane contentBorderPane = new BorderPane();
        contentBorderPane.setTop(contentHeader);
        contentBorderPane.setCenter(contentTextArea);
        contentBorderPane.setBottom(licenceLink);
        contentTextArea.setEditable(false);
        Window window = alert.getDialogPane().getScene().getWindow();
        Intrinsics.checkNotNull(window, "null cannot be cast to non-null type javafx.stage.Stage");
        Stage stage = (Stage)window;
        ObservableList<Image> observableList = stage.getIcons();
        AppDDSFX appDDSFX = dds;
        Intrinsics.checkNotNull(appDDSFX);
        observableList.add(appDDSFX.createFaviconImage());
        stage.getScene().getRoot().setStyle(fxDoc.getScene().getRoot().getStyle());
        alert.getDialogPane().setPrefSize(600.0, 400.0);
        alert.getDialogPane().setHeaderText(appDisplayName);
        alert.getDialogPane().setContent(contentBorderPane);
        alert.showAndWait();
    }

    @NotNull
    public final Stage createLogStage(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Stage rtn2 = new Stage();
        rtn2.setTitle("Logs");
        BorderPane borderPane = new BorderPane();
        TextArea logTa = new TextArea();
        logTa.setPromptText("Click refresh to load log from file.");
        Button clearLog = PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> JavaFXapp.createLogStage$lambda$4(logTa), "Clear", false, "Clear logs.");
        Button refreshLog = PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> JavaFXapp.createLogStage$lambda$5(logTa), "Refresh", false, "Refresh log.");
        FontManagerFX.INSTANCE.register(fxDoc, logTa);
        FlowPane topFlow = new FlowPane();
        topFlow.getChildren().add(refreshLog);
        topFlow.getChildren().add(clearLog);
        topFlow.getChildren().add(PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> JavaFXapp.createLogStage$lambda$6(logTa), "System", false, ""));
        borderPane.setTop(topFlow);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.fitToHeightProperty().setValue(true);
        scrollPane.fitToWidthProperty().setValue(true);
        scrollPane.setContent(logTa);
        borderPane.setCenter(scrollPane);
        this.update(logTa);
        Zombie.INSTANCE.addStopAction(JavaFXapp::createLogStage$lambda$7);
        rtn2.setScene(new Scene(borderPane, 600.0, 400.0));
        ObservableList<Image> observableList = rtn2.getIcons();
        AppDDSFX appDDSFX = dds;
        Intrinsics.checkNotNull(appDDSFX);
        observableList.add(appDDSFX.createFaviconImage());
        return rtn2;
    }

    private final void update(TextArea logTa) {
        logTa.setText(Logpan.INSTANCE.getEntryStackAsTextlg());
    }

    private final void doShowLog(FxDoc fxDoc) {
        if (logStage == null) {
            return;
        }
        Stage stage = logStage;
        Intrinsics.checkNotNull(stage);
        if (!stage.isShowing()) {
            Stage stage2 = logStage;
            Intrinsics.checkNotNull(stage2);
            stage2.getScene().getRoot().setStyle(fxDoc.getScene().getRoot().getStyle());
            Stage stage3 = logStage;
            Intrinsics.checkNotNull(stage3);
            stage3.show();
        }
        Stage stage4 = logStage;
        Intrinsics.checkNotNull(stage4);
        stage4.toFront();
        Stage stage5 = logStage;
        Intrinsics.checkNotNull(stage5);
        stage5.requestFocus();
    }

    private final synchronized void saveOpenWindowStateGlobally() {
        boolean firstTime = true;
        StringWriter sw = new StringWriter();
        for (Anchor anchor : AnchorFactory.INSTANCE.getAnchors()) {
            String path = URLEncoder.encode(anchor.getPath(), StandardCharsets.UTF_8);
            if (firstTime) {
                firstTime = false;
            } else {
                sw.append(",");
            }
            sw.append(path);
        }
        String string = DeskApp4XFactory.INSTANCE.getPanApplication().getFilesKey();
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        GlobalPropertiesKt.globalPropsPut(string, string2);
        GlobalPropertiesKt.globalPropsFlush();
    }

    public final void doExit() {
        Zombie.INSTANCE.stop();
        this.saveOpenWindowStateGlobally();
        for (Anchor anchor : AnchorFactory.INSTANCE.getAnchors()) {
            Intrinsics.checkNotNull(anchor, "null cannot be cast to non-null type com.panopset.fxapp.FxDoc");
            ((FxDoc)anchor).closeWindow();
        }
    }

    @Nullable
    public final Stage findStage() {
        return this.findActiveStage();
    }

    @Nullable
    public final AppDDSFX getDds() {
        return dds;
    }

    public final void setDds(@Nullable AppDDSFX appDDSFX) {
        dds = appDDSFX;
    }

    public final void newWindow() {
        this.addStage();
    }

    public final void showAboutPanel(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.doAbout(fxDoc);
    }

    public final void showLogPanel(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.doShowLog(fxDoc);
    }

    public final void saveWindow(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.doSave(fxDoc);
    }

    public final void saveWindowAs(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.doSaveAs(fxDoc);
    }

    public final void openWindowFromFile() {
        this.doOpen();
    }

    public final void panExit() {
        this.doExit();
    }

    public final void closeWindow(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        int size = AnchorFactory.INSTANCE.getAnchors().size();
        if (size == 1) {
            this.doExit();
            return;
        }
        fxDoc.closeWindow();
        AnchorFactory.INSTANCE.removeAnchor(fxDoc);
    }

    private static final void launch$lambda$1(Ref.ObjectRef $fxDoc) {
        if ($fxDoc.element != null) {
            logStage = INSTANCE.createLogStage((FxDoc)$fxDoc.element);
        }
    }

    private static final void doAbout$lambda$3$lambda$2() {
        try {
            Desktop.getDesktop().browse(new URI("https://github.com/panopset/src/blob/main/LICENSE"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    private static final void doAbout$lambda$3(ActionEvent it) {
        if (Desktop.isDesktopSupported()) {
            new Thread(JavaFXapp::doAbout$lambda$3$lambda$2).start();
        }
    }

    private static final Unit createLogStage$lambda$4(TextArea $logTa) {
        Logz.INSTANCE.clear();
        $logTa.setText("");
        return Unit.INSTANCE;
    }

    private static final Unit createLogStage$lambda$5(TextArea $logTa) {
        INSTANCE.update($logTa);
        return Unit.INSTANCE;
    }

    private static final Unit createLogStage$lambda$6(TextArea $logTa) {
        $logTa.setText(SysInfo.INSTANCE.toString());
        return Unit.INSTANCE;
    }

    private static final void createLogStage$lambda$7() {
        block0: {
            Stage stage = logStage;
            if (stage == null) break block0;
            stage.close();
        }
    }
}

