/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.bootstrap;

import com.panopset.compat.AppVersion;
import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.marin.bootstrap.Platform;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/panopset/marin/bootstrap/PlatformMap;", "", "<init>", "()V", "map", "Ljava/util/SortedMap;", "", "Lcom/panopset/marin/bootstrap/Platform;", "getMap", "()Ljava/util/SortedMap;", "addPlatformProperties", "", "file", "Ljava/io/File;", "desk"})
public final class PlatformMap {
    @NotNull
    private final SortedMap<String, Platform> map;

    public PlatformMap() {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        this.map = sortedMap;
        File launchDir = new File(".");
        String string = launchDir.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue(string, "getCanonicalPath(...)");
        if (StringsKt.indexOf$default((CharSequence)string, "desk", 0, false, 6, null) > -1) {
            launchDir = new File("./../..");
        }
        File[] fileArray = launchDir.listFiles();
        Intrinsics.checkNotNull(fileArray);
        for (File file : fileArray) {
            String string2;
            if (file == null || !Intrinsics.areEqual(FilesKt.getExtension(file), "properties") || file.getName().length() <= 3) continue;
            Intrinsics.checkNotNullExpressionValue(file.getName(), "getName(...)");
            int n = 0;
            int n2 = 3;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            if (!Intrinsics.areEqual(string3, "app")) continue;
            this.addPlatformProperties(file);
        }
        if (this.map.isEmpty()) {
            Logz.INSTANCE.errorMsg("No platform properties found in", launchDir);
        }
    }

    @NotNull
    public final SortedMap<String, Platform> getMap() {
        return this.map;
    }

    private final void addPlatformProperties(File file) {
        String fxArch;
        String string;
        String dspOrd;
        Properties props = Fileop.INSTANCE.loadProps(file);
        String string2 = props.getProperty("DSPORD");
        if (string2 == null) {
            string2 = dspOrd = "4";
        }
        if ((string = props.getProperty("FX_ARCH")) == null) {
            string = "";
        }
        if (((CharSequence)(fxArch = string)).length() == 0) {
            return;
        }
        if (((CharSequence)fxArch).length() == 0) {
            return;
        }
        String installerPrefix = props.getProperty("INSTALLER_PFX");
        String installerSuffix = props.getProperty("INSTALLER_SFX");
        String artifactName = installerPrefix + AppVersion.INSTANCE.getVersion() + installerSuffix;
        ((Map)this.map).put(dspOrd, new Platform(fxArch, artifactName));
    }
}

